<?php
class fang
{
	private $db;
	private $loupan_table;
	private $loupan_ask;
	private $zhongjie_table;
	private $postcount_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->loupan_table=LA_PRE.'loupan';
		$this->loupan_ask=LA_PRE.'loupan_ask';
		$this->loupan_zhongjie=LA_PRE.'loupan_zhongjie';
		$this->postcount_table=LA_PRE.'postcount';
	}

	function zhongjielist($userid=0,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND userid='.$userid:'';
		$where.=$starttime?' AND updatetime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND updatetime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND mendian LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->loupan_zhongjie,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function zhongjiestatis()
	{
		global $siteidobj,$_siteid;
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->loupan_zhongjie` WHERE $where");
	}
	
	function getzhongjie($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->loupan_zhongjie` WHERE `$this->loupan_zhongjie`.`id`=$id");
	}

	function getzhongjiebyuserid($userid)
	{	
		$userid=intval($userid);
		return $this->db->fetch_one("SELECT * FROM `$this->loupan_zhongjie` WHERE `$this->loupan_zhongjie`.`userid`=$userid");
	}

	function zhongjie_delete($ids=array(),$userid)
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getzhongjie($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$hash_table=get_hash_table($this->loupan_zhongjie.'_data',$id,$modelobj->subformcount(56));
					$this->db->mysql_delete($this->loupan_zhongjie,$id);
					$this->db->mysql_delete($hash_table,$id,'mid');
				}
			}
		}
		return true;
	}

	function admin_zhongjie_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);
	
		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$mem=array();
		$mem['gradeid']=3;
		$mem['username']='company_'.TIME;
		$mem['password']=md5(mt_rand(100000,999999));
		$mem['email']='company_'.TIME.'@niubicms.com';
		$mem['company']=$info['mendian'];
		$info['userid']=$memberobj->admin_companyadd($mem);

		$info['updatetime']=TIME;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->insert($hash_table,$info,true);
	}

	function admin_zhongjie_edit($info,$id,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$id=intval($id);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		$info['updatetime']=TIME;

		$info['siteid']=intval($_SESSION['siteid']);
		$this->db->update($this->loupan_zhongjie,$info,'id='.$id);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->update($hash_table,$info,'mid='.$id);
	}

	function member_zhongjie_edit($info,$modelid=0,$extend=0,$userid=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$userid=intval($userid);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		$info['updatetime']=TIME;
		$info['userid']=$userid;
		$info['siteid']=intval($_SESSION['siteid']);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$coninfo=$this->getzhongjiebyuserid($userid);
		if($coninfo)
		{
			$this->db->update($this->loupan_zhongjie,$info,'userid='.$userid);
			$this->db->update($hash_table,$info,'mid='.$coninfo['id']);
		}
		else
		{
			$info['mid']=$this->db->insert($this->loupan_zhongjie,$info);
			$this->db->insert($hash_table,$info);
		}
		
		$cacheobj->clear();
		return true;
	}

	function zhongjieset($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getzhongjie($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->loupan_zhongjie,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function formatzhongjieurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-zhongjie-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$modinfo=$moduleobj->get(15);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],15);
			
			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'zhongjie-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'index.php?mod='.$modinfo['folder'].'&action=showzhongjie&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/zhongjie-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/index.php?mod='.$modinfo['folder'].'&action=showzhongjie&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}

	function asklist($loupanid=0,$isreply=-1,$starttime='',$endtime='',$k='',$userid=0)
	{
		global $page,$_siteid,$siteidobj;
		$loupanid=intval($loupanid);
		$isreply=intval($isreply);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$loupanid?' AND loupanid='.$loupanid:'';
		$where.=$userid?' AND userid='.$userid:'';
		$where.=$isreply==0?' AND reply=\'\'':'';
		$where.=$starttime?' AND asktime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND asktime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND content LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->loupan_ask,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function askinfo($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->loupan_ask` WHERE `$this->loupan_ask`.`id`=$id");
	}

	function ask_reply($reply,$id)
	{
		return $this->db->update($this->loupan_ask,array('reply'=>htmlspecialchars($reply),'replytime'=>TIME),'id='.intval($id));
	}

	function ask_delete($ids=array(),$userid=0)
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->askinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$coninfo=$this->getloupan($cinfo['loupanid']);
					if(!$userid || $userid==$coninfo['userid'])
					{
						$this->db->mysql_delete($this->loupan_ask,$id,'id');
					}
				}
			}
		}

		return true;
	}

	function askstatis($loupanid=0)
	{
		global $siteidobj,$_siteid;
		$loupanid=intval($loupanid);

		$where=$loupanid?'loupanid='.$loupanid:'1';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->loupan_ask` WHERE $where");
	}

	function loupanlist($moduleid=0,$status=-1,$ishidden=-1,$userid=0,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$moduleid=intval($moduleid);

		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$moduleid?' AND moduleid='.$moduleid:'';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$ishidden>=0?' AND ishidden='.$ishidden:'';
		$where.=$userid?' AND userid='.$userid:'';
		$where.=$starttime?' AND updatetime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND updatetime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='updatetime DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->loupan_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function loupanstatis($moduleid=7,$status=-1,$isdeleted=0)
	{
		global $siteidobj,$_siteid;
		$moduleid=intval($moduleid);
		$status=intval($status);
		$isdeleted=intval($isdeleted);

		$where=$_siteid?' siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$moduleid?' AND moduleid='.$moduleid:'';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->loupan_table` WHERE $where");
	}

	function loupanset($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getloupan($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->loupan_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function loupan_delete($ids=array(),$userid)
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getloupan($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$hash_table=get_hash_table($this->loupan_table.'_data',$id,$modelobj->subformcount(53));
					$this->db->mysql_delete($this->loupan_table,$id);
					$this->db->mysql_delete($hash_table,$id,'mid');
				}
			}
		}
		return true;
	}


	function con_postcount($userid,$moduleid)
	{
		$moduleid=intval($moduleid);
		$userid=intval($userid);
		$this->db->query("DELETE FROM `$this->postcount_table` WHERE `$this->postcount_table`.`moduleid`=$moduleid AND `$this->postcount_table`.`datetime`<'".strtotime(date('Y-m-d',(TIME-24*3600)))."' AND  `$this->postcount_table`.`userid`=$userid");
		$r=$this->db->fetch_one("SELECT * FROM `$this->postcount_table` WHERE `$this->postcount_table`.`userid`=$userid AND `$this->postcount_table`.`datetime`='".strtotime(date('Y-m-d',TIME))."' AND `$this->postcount_table`.`moduleid`=$moduleid");
		return $r?intval($r['counter']-1):-1;
	}

/*  mem */
	function loupan_setdelete($id,$userid)
	{
		$id=intval($id);
		$userid=intval($userid);
		return $this->db->query("DELETE FROM `$this->loupan_table` WHERE `$this->loupan_table`.`id`=$id AND  `$this->loupan_table`.`userid`=$userid");
	}

	function loupan_sethide($id,$userid,$ishidden=1)
	{
		$id=intval($id);
		$userid=intval($userid);
		$ishidden=intval($ishidden);
		return $this->db->query("UPDATE `$this->loupan_table` SET `$this->loupan_table`.`ishidden`=$ishidden WHERE `$this->loupan_table`.`id`=$id AND  `$this->loupan_table`.`userid`=$userid");
	}

	function loupan_settop($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;
		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);

		$tiao=$settings['top_type']==0?$_point:$_amount;
		if($settings['top_fee']<=$tiao)
		{
			if($settings['top_type']==0)
			{
				$memberobj->set($userid,array('point'=>max(0,$_point-$settings['top_fee'])));
			}
			else
			{
				$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['top_fee'])));
			}
			return $this->db->query("UPDATE `$this->loupan_table` SET `$this->loupan_table`.`istop`='".(TIME+24*3600)."' WHERE `$this->loupan_table`.`id`=$id AND  `$this->loupan_table`.`userid`=$userid");
		}
		
		return false;
	}

	function loupan_settopic($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;
		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);

		$tiao=$settings['top_type']==0?$_point:$_amount;
		if($settings['top_fee']<=$tiao)
		{
			if($settings['top_type']==0)
			{
				$memberobj->set($userid,array('point'=>max(0,$_point-$settings['top_fee'])));
			}
			else
			{
				$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['top_fee'])));
			}
			return $this->db->query("UPDATE `$this->loupan_table` SET `$this->loupan_table`.`istopic`='".(TIME+24*3600)."' WHERE `$this->loupan_table`.`id`=$id AND  `$this->loupan_table`.`userid`=$userid");
		}
		
		return false;
	}

	function loupan_setfocus($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;
		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);

		$tiao=$settings['top_type']==0?$_point:$_amount;
		if($settings['top_fee']<=$tiao)
		{
			if($settings['top_type']==0)
			{
				$memberobj->set($userid,array('point'=>max(0,$_point-$settings['top_fee'])));
			}
			else
			{
				$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['top_fee'])));
			}
			return $this->db->query("UPDATE `$this->loupan_table` SET `$this->loupan_table`.`isfocus`='".(TIME+24*3600)."' WHERE `$this->loupan_table`.`id`=$id AND  `$this->loupan_table`.`userid`=$userid");
		}
		
		return false;
	}

	function loupan_refresh($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;

		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);
		
		$counter=$this->con_postcount($userid,$moduleid);

		if($settings['membergrade_count'][$_gradeid]>$counter)
		{
			if($counter==-1)
			{
				$this->db->insert($this->postcount_table,array('userid'=>$userid,'moduleid'=>$moduleid,'counter'=>1,'datetime'=>strtotime(date('Y-m-d',TIME))));
			}
			else
			{
				$this->db->query("UPDATE `$this->postcount_table` SET `$this->postcount_table`.`counter`=`$this->postcount_table`.`counter`+1 WHERE `$this->postcount_table`.`userid`=$userid AND  `$this->postcount_table`.`moduleid`=$moduleid AND  `$this->postcount_table`.`datetime`='".strtotime(date('Y-m-d',TIME))."'");
			}
			$this->db->query("UPDATE `$this->loupan_table` SET `$this->loupan_table`.`updatetime`=".TIME." WHERE `$this->loupan_table`.`id`=$id AND  `$this->loupan_table`.`userid`=$userid");
			return true;
		}
		else
		{
			$tiao=$settings['pay_type']==0?$_point:$_amount;
			if($settings['pay_fee']<=$tiao)
			{
				if($settings['pay_type']==0)
				{
					$memberobj->set($userid,array('point'=>max(0,$_point-$settings['pay_fee'])));
				}
				else
				{
					$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['pay_fee'])));
				}

				$this->db->query("UPDATE `$this->loupan_table` SET `$this->loupan_table`.`updatetime`=".TIME." WHERE `$this->loupan_table`.`id`=$id AND  `$this->loupan_table`.`userid`=$userid");
				return true;
			}
		}
		return false;
	}

	function member_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['updatetime']=TIME;
		$info['clicks']=$info['comments']=0;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['userid']=$_userid;
		$info['adminpost']=0;
		$counter=$conobj->con_postcount($_userid,15);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		if($settings['membergrade_count'][$_gradeid]>$counter)
		{
			if($counter==-1)
			{
				$this->db->insert($this->postcount_table,array('userid'=>$_userid,'moduleid'=>15,'counter'=>1,'datetime'=>strtotime(date('Y-m-d',TIME))));
			}
			else
			{
				$this->db->query("UPDATE `$this->postcount_table` SET `$this->postcount_table`.`counter`=`$this->postcount_table`.`counter`+1 WHERE `$this->postcount_table`.`userid`=$_userid AND  `$this->postcount_table`.`moduleid`=15 AND  `$this->postcount_table`.`datetime`='".strtotime(date('Y-m-d',TIME))."'");
			}
			$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
			$this->db->insert($hash_table,$info,true);

		}
		else
		{
			$tiao=$settings['pay_type']==0?$_point:$_amount;
			if($settings['pay_fee']<=$tiao)
			{
				if($settings['pay_type']==0)
				{
					$memberobj->set($_userid,array('point'=>max(0,$_point-$settings['pay_fee'])));
				}
				else
				{
					$memberobj->set($_userid,array('amount'=>max(0,$_amount-$settings['pay_fee'])));
				}
				$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
				$this->db->insert($hash_table,$info,true);
			}
			else
			{
				return false;
			}
		}
		
		$cacheobj->clear();
		return true;
	}

	function member_edit($info,$modelid=0,$extend=0,$id=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$id=intval($id);
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['updatetime']=TIME;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['userid']=$_userid;
		$info['adminpost']=0;
		$counter=$conobj->con_postcount($_userid,15);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		if($settings['membergrade_count'][$_gradeid]>$counter)
		{
			if($counter==-1)
			{
				$this->db->insert($this->postcount_table,array('userid'=>$_userid,'moduleid'=>15,'counter'=>1,'datetime'=>strtotime(date('Y-m-d',TIME))));
			}
			else
			{
				$this->db->query("UPDATE `$this->postcount_table` SET `$this->postcount_table`.`counter`=`$this->postcount_table`.`counter`+1 WHERE `$this->postcount_table`.`userid`=$_userid AND  `$this->postcount_table`.`moduleid`=15 AND  `$this->postcount_table`.`datetime`='".strtotime(date('Y-m-d',TIME))."'");
			}
			$this->db->update(LA_PRE.$modelinfo['tbname'],$info,'id='.$id);
			$this->db->update($hash_table,$info,'mid='.$id);

		}
		else
		{
			$tiao=$settings['pay_type']==0?$_point:$_amount;
			if($settings['pay_fee']<=$tiao)
			{
				if($settings['pay_type']==0)
				{
					$memberobj->set($_userid,array('point'=>max(0,$_point-$settings['pay_fee'])));
				}
				else
				{
					$memberobj->set($_userid,array('amount'=>max(0,$_amount-$settings['pay_fee'])));
				}
				$this->db->update(LA_PRE.$modelinfo['tbname'],$info,'id='.$id);
				$this->db->update($hash_table,$info,'mid='.$id);
			}
			else
			{
				return false;
			}
		}
		
		$cacheobj->clear();
		return true;
	}

	function admin_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['updatetime']=TIME;
		$info['clicks']=$info['comments']=0;
		$info['istopic']=$info['istopic']?(TIME+24*3600):0;
		$info['istop']=$info['istop']?(TIME+24*3600):0;
		$info['isfocus']=($info['isfocus'] && is_image($info['thumb']))?(TIME+24*3600):0;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['adminpost']=1;
		$info['description']=$info['description']?$info['description']:sub_string(trim(strip_tags($info['content'])),255);
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->insert($hash_table,$info,true);
	}

	function admin_edit($info,$id,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$id=intval($id);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		$info['updatetime']=TIME;

		$info['siteid']=intval($_SESSION['siteid']);
		$info['description']=$info['description']?$info['description']:sub_string(trim(strip_tags($info['content'])),255);
		$this->db->update($this->loupan_table,$info,'id='.$id);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->update($hash_table,$info,'mid='.$id);
	}

	function getloupan($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->loupan_table` WHERE `$this->loupan_table`.`id`=$id");
	}

	function formatloupanurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-loupan-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$coninfo=$this->getloupan($id);

			$modinfo=$moduleobj->get(intval($coninfo['moduleid']));
			$modsettings=$configobj->getconfig($_SESSION['siteid'],$coninfo['moduleid']);
			
			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'loupan-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'index.php?mod='.$modinfo['folder'].'&action=showloupan&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/loupan-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/index.php?mod='.$modinfo['folder'].'&action=showloupan&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}
}
?>
